<?php

namespace App\Models\UserOffice;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserOffice extends Model 
{

    protected $table = 'users_offices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'office_id');

    public function office()
    {
        return $this->belongsToMany('Office', 'office_id');
    }

    public function user()
    {
        return $this->belongsToMany('User', 'user_id');
    }

}